////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBWorkspace.h
//    An workspace responds to application requests to perform a variety of services such as:
//       • Opening, manipulating, and obtaining information about files and devices
//       • Tracking changes to the file system, devices, and the user database
//       • Getting and setting Finder/Explorer information for files.
//       • Launching applications
//
//  Copyright © 2012-2013 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//  09/03/13  B.D.D.  Added OpenFileWithDefaultApplication.
//	02/15/12  K.L.S.  Created File.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

class CPString;
class CPURL;

class EXTERNAL_API OBWorkspace
{
public:
	static bool LaunchApplication(const CPString& ApplicationName);
	static bool OpenFileWithDefaultApplication(const CPString& FilePath);
	static bool OpenFileWithApplication(const CPString& FilePath, const CPString& ApplicationName);
	static bool SelectFileInFileViewerRootedAtPath(const CPString& FilePath, const CPString& RootPath);
	static CPURL URLForApplicationToOpenURL(const CPURL& URL);
	static bool OpenURL(const CPURL& Url);
};
